/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.client.model;

import com.flemmli97.tenshilib.TenshiLib;
import com.flemmli97.tenshilib.client.model.ModelRendererPlus;
import com.flemmli97.tenshilib.common.utils.ArrayUtils;
import com.flemmli97.tenshilib.common.utils.MathUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class BlockBenchAnimations {
    private static final Gson gson = new Gson();
    private final Map<String, Animation> animations = Maps.newHashMap();

    public BlockBenchAnimations(Model model, ResourceLocation res) {
        InputStream input = BlockBenchAnimations.class.getResourceAsStream("/assets/" + res.func_110624_b() + "/" + res.func_110623_a());
        if (input == null) {
            TenshiLib.logger.error("Couldn't find animation: " + res);
            return;
        }
        try {
            JsonObject obj = (JsonObject)gson.getAdapter(JsonObject.class).read(gson.newJsonReader((Reader)new InputStreamReader(input)));
            if (obj.has("animations")) {
                for (Map.Entry anims : obj.getAsJsonObject("animations").entrySet()) {
                    if (!(anims.getValue() instanceof JsonObject)) continue;
                    this.animations.put((String)anims.getKey(), new Animation(model, (JsonObject)anims.getValue()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void doAnimation(String name, int ticker, float partialTicks) {
        Animation animation = this.animations.get(name);
        if (animation != null) {
            animation.animate(ticker, partialTicks);
        }
    }

    public int animationLength(String name) {
        Animation animation = this.animations.get(name);
        return animation != null ? animation.length : 0;
    }

    public String toString() {
        return "Animation: " + this.animations;
    }

    public static class AnimationComponent {
        private final String name;
        private final ModelRenderer model;
        private float[][] rotations;
        private float[][] positions;
        private float[][] scales;

        public AnimationComponent(String name, ModelRenderer part, JsonObject obj) {
            JsonArray arr2;
            this.name = name;
            this.model = part;
            int i = 0;
            if (obj.has("position")) {
                JsonObject position = this.tryGet(obj, "position");
                this.positions = new float[position.size()][4];
                for (Map.Entry e : position.entrySet()) {
                    if (!(e.getValue() instanceof JsonArray)) continue;
                    arr2 = (JsonArray)e.getValue();
                    this.positions[i] = new float[]{Math.round(Float.parseFloat((String)e.getKey()) * 20.0f), arr2.get(0).getAsFloat(), arr2.get(1).getAsFloat(), arr2.get(2).getAsFloat()};
                    ++i;
                }
                Arrays.sort(this.positions, Comparator.comparingDouble(arr -> arr[0]));
            }
            if (obj.has("rotation")) {
                JsonObject rotation = this.tryGet(obj, "rotation");
                this.rotations = new float[rotation.size()][4];
                i = 0;
                for (Map.Entry e : rotation.entrySet()) {
                    if (!(e.getValue() instanceof JsonArray)) continue;
                    arr2 = (JsonArray)e.getValue();
                    this.rotations[i] = new float[]{Math.round(Float.parseFloat((String)e.getKey()) * 20.0f), MathUtils.degToRad(arr2.get(0).getAsFloat()), MathUtils.degToRad(arr2.get(1).getAsFloat()), MathUtils.degToRad(arr2.get(2).getAsFloat())};
                    ++i;
                }
                Arrays.sort(this.rotations, Comparator.comparingDouble(arr -> arr[0]));
            }
            if (obj.has("scale")) {
                JsonObject scale = this.tryGet(obj, "scale");
                this.scales = new float[scale.size()][4];
                i = 0;
                for (Map.Entry e : scale.entrySet()) {
                    if (!(e.getValue() instanceof JsonArray)) continue;
                    arr2 = (JsonArray)e.getValue();
                    this.scales[i] = new float[]{Math.round(Float.parseFloat((String)e.getKey()) * 20.0f), arr2.get(0).getAsFloat() - 1.0f, arr2.get(1).getAsFloat() - 1.0f, arr2.get(2).getAsFloat() - 1.0f};
                    ++i;
                }
                Arrays.sort(this.scales, Comparator.comparingDouble(arr -> arr[0]));
            }
        }

        private JsonObject tryGet(JsonObject obj, String name) {
            JsonElement el = obj.get(name);
            if (el.isJsonObject()) {
                return (JsonObject)el;
            }
            if (el.isJsonArray()) {
                JsonObject val = new JsonObject();
                val.add("0", el);
                return val;
            }
            return null;
        }

        public void animate(int ticker, float partialTicks) {
            float prog;
            int id;
            float actualTick = Math.max((float)(ticker - 1) + partialTicks, 0.0f);
            if (this.positions != null) {
                if (this.positions.length == 1) {
                    this.model.field_78800_c += this.positions[0][1];
                    this.model.field_78797_d -= this.positions[0][2];
                    this.model.field_78798_e += this.positions[0][3];
                } else {
                    id = 1;
                    float[] pos = this.positions[id];
                    while (pos[0] < (float)ticker && ++id < this.positions.length) {
                        pos = this.positions[id];
                    }
                    float[] posPrev = this.positions[id - 1];
                    prog = MathHelper.func_76131_a((float)((actualTick - posPrev[0]) / (pos[0] - posPrev[0])), (float)0.0f, (float)1.0f);
                    this.model.field_78800_c += this.interpolate(posPrev[1], pos[1], prog);
                    this.model.field_78797_d -= this.interpolate(posPrev[2], pos[2], prog);
                    this.model.field_78798_e += this.interpolate(posPrev[3], pos[3], prog);
                }
            }
            if (this.rotations != null) {
                if (this.rotations.length == 1) {
                    this.model.field_78795_f += this.rotations[0][1];
                    this.model.field_78796_g += this.rotations[0][2];
                    this.model.field_78808_h += this.rotations[0][3];
                } else {
                    id = 1;
                    float[] rot = this.rotations[id];
                    while (rot[0] < (float)ticker && ++id < this.rotations.length) {
                        rot = this.rotations[id];
                    }
                    float[] rotPrev = this.rotations[id - 1];
                    prog = MathHelper.func_76131_a((float)((actualTick - rotPrev[0]) / (rot[0] - rotPrev[0])), (float)0.0f, (float)1.0f);
                    this.model.field_78795_f += this.interpolate(rotPrev[1], rot[1], prog);
                    this.model.field_78796_g += this.interpolate(rotPrev[2], rot[2], prog);
                    this.model.field_78808_h += this.interpolate(rotPrev[3], rot[3], prog);
                }
            }
            if (this.scales != null && this.model instanceof ModelRendererPlus) {
                ModelRendererPlus plus = (ModelRendererPlus)this.model;
                if (this.scales.length == 1) {
                    plus.scaleX += this.scales[0][3];
                    plus.scaleY += this.scales[0][3];
                    plus.scaleZ += this.scales[0][3];
                } else {
                    int id2 = 1;
                    float[] scale = this.scales[id2];
                    while (scale[0] < (float)ticker && ++id2 < this.scales.length) {
                        scale = this.scales[id2];
                    }
                    float[] scalePrev = this.scales[id2 - 1];
                    float prog2 = MathHelper.func_76131_a((float)((actualTick - scalePrev[0]) / (scale[0] - scalePrev[0])), (float)0.0f, (float)1.0f);
                    plus.scaleX += this.interpolate(scalePrev[1], scale[1], prog2);
                    plus.scaleY += this.interpolate(scalePrev[2], scale[2], prog2);
                    plus.scaleZ += this.interpolate(scalePrev[3], scale[3], prog2);
                }
            }
        }

        private float interpolate(float start, float end, float progress) {
            return start + (end - start) * progress;
        }

        public String toString() {
            return String.format("%s rot: {%s}; pos: {%s}; scale: {%s}", this.name, ArrayUtils.arrayToString(this.rotations, arr -> "[" + ArrayUtils.arrayToString(arr) + "]"), ArrayUtils.arrayToString(this.positions, arr -> "[" + ArrayUtils.arrayToString(arr) + "]"), ArrayUtils.arrayToString(this.scales, arr -> "[" + ArrayUtils.arrayToString(arr) + "]"));
        }
    }

    public static class Animation {
        public final int length;
        public final boolean loop;
        private final List<AnimationComponent> components = Lists.newArrayList();

        public Animation(Model model, JsonObject json) {
            this.length = (int)Math.floor(json.get("animation_length").getAsDouble() * 20.0 + 1.0);
            this.loop = json.has("loop") && json.get("loop").getAsBoolean();
            JsonObject components = json.getAsJsonObject("bones");
            for (Field field : model.getClass().getFields()) {
                if (!ModelRenderer.class.isAssignableFrom(field.getType()) || !components.has(field.getName())) continue;
                try {
                    this.components.add(new AnimationComponent(field.getName(), (ModelRenderer)field.get(model), components.getAsJsonObject(field.getName())));
                }
                catch (IllegalAccessException e) {
                    TenshiLib.logger.error("Error accessing field value: {}", (Object)field.getName());
                    e.printStackTrace();
                }
            }
        }

        public void animate(int ticker, float partialTicks) {
            if (this.loop) {
                ticker %= this.length;
            }
            for (AnimationComponent comp : this.components) {
                comp.animate(ticker, partialTicks);
            }
        }

        public String toString() {
            return String.format("\nloop: %b, length: %d, components: %s", this.loop, this.length, this.components.toString());
        }
    }
}

